/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.client.BlockColorMultipliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.command.CommandBase;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LeavesPropertiesJson
extends LeavesProperties {
    static List<LeavesPropertiesJson> resolutionList = new ArrayList<LeavesPropertiesJson>();
    private int lightRequirement = 13;
    private int smotherLeavesMax = 4;
    private JsonObject jsonObj = null;
    private boolean connectAnyRadius = false;
    private int flammability = 60;
    private int fireSpreadSpeed = 30;
    protected ILeavesUpdate leavesUpdate = (w, p, s, r, l) -> true;
    protected static Map<String, Function<JsonElement, PrimitiveLeavesComponents>> blockstateFinderMap = new HashMap<String, Function<JsonElement, PrimitiveLeavesComponents>>();
    private JsonPrimitive colorPrimitive = null;
    @SideOnly(value=Side.CLIENT)
    private IBlockColor colorMultiplier;

    public LeavesPropertiesJson(String jsonData) {
        this(LeavesPropertiesJson.getJsonObject(jsonData));
    }

    public LeavesPropertiesJson(JsonObject jsonObj) {
        super(ModBlocks.blockStates.air, ItemStack.field_190927_a);
        this.jsonObj = jsonObj;
        resolutionList.add(this);
    }

    public void resolve() {
        if (this.jsonObj != null) {
            for (Map.Entry entry : this.jsonObj.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                if ("color".equals(key)) {
                    if (!element.isJsonPrimitive()) continue;
                    this.colorPrimitive = element.getAsJsonPrimitive();
                    continue;
                }
                if ("leaves".equals(key)) {
                    if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                        LeavesPropertiesJson.getPrimitiveLeaves(element.getAsString()).assignTo(this);
                        continue;
                    }
                    if (!element.isJsonObject()) continue;
                    LeavesPropertiesJson.getPrimitiveLeaves(element.getAsJsonObject()).assignTo(this);
                    continue;
                }
                if ("cellkit".equals(key)) {
                    ICellKit kit = TreeRegistry.findCellKit(element.getAsString());
                    if (kit == null) continue;
                    this.cellKit = kit;
                    continue;
                }
                if ("smother".equals(key)) {
                    this.smotherLeavesMax = MathHelper.func_76125_a((int)element.getAsInt(), (int)0, (int)64);
                    continue;
                }
                if ("light".equals(key)) {
                    this.lightRequirement = MathHelper.func_76125_a((int)element.getAsInt(), (int)0, (int)15);
                    continue;
                }
                if ("connectAny".equals(key)) {
                    if (!element.isJsonPrimitive()) continue;
                    this.connectAnyRadius = element.getAsBoolean();
                    continue;
                }
                if ("flammability".equals(key)) {
                    if (!element.isJsonPrimitive()) continue;
                    this.flammability = element.getAsInt();
                    continue;
                }
                if (!"fireSpreadSpeed".equals(key) || !element.isJsonPrimitive()) continue;
                this.fireSpreadSpeed = element.getAsInt();
            }
            this.jsonObj = null;
        }
    }

    private static PrimitiveLeavesComponents getPrimitiveLeaves(String leavesDesc) {
        IBlockState state = LeavesPropertiesJson.getBlockState(leavesDesc);
        ItemStack stack = ItemStack.field_190927_a;
        if (state.func_177230_c() != Blocks.field_150350_a) {
            int meta = state.func_177230_c().func_180651_a(state);
            if (state.func_177230_c() == Blocks.field_150361_u && meta >= 4) {
                meta -= 4;
            }
            stack = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, meta);
        }
        return new PrimitiveLeavesComponents(state, stack);
    }

    private static PrimitiveLeavesComponents getPrimitiveLeaves(JsonObject jsonObj) {
        for (Map.Entry entry : jsonObj.entrySet()) {
            String name = (String)entry.getKey();
            PrimitiveLeavesComponents comp = LeavesPropertiesJson.findPrimitiveComponents(name, (JsonElement)entry.getValue());
            if (comp == null) continue;
            return comp;
        }
        return new PrimitiveLeavesComponents(Blocks.field_150350_a.func_176223_P(), ItemStack.field_190927_a);
    }

    private static IBlockState getBlockState(String blockStateDesc) {
        String blockString = blockStateDesc;
        String argString = "default";
        String[] args = blockStateDesc.split(" ");
        if (args.length == 2) {
            blockString = args[0];
            argString = args[1];
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockString));
        try {
            return CommandBase.func_190794_a((Block)block, (String)argString);
        }
        catch (InvalidBlockStateException | NumberInvalidException e) {
            e.printStackTrace();
            return block.func_176223_P();
        }
    }

    public static JsonObject getJsonObject(String jsonData) {
        try {
            JsonParser parser = new JsonParser();
            JsonElement je = parser.parse(jsonData.replace('`', '\"'));
            return je.getAsJsonObject();
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public static void resolveAll() {
        for (LeavesPropertiesJson res : resolutionList) {
            res.resolve();
        }
    }

    public static void cleanUp() {
        resolutionList = null;
        blockstateFinderMap = null;
    }

    @Override
    public int getLightRequirement() {
        return this.lightRequirement;
    }

    @Override
    public int getSmotherLeavesMax() {
        return this.smotherLeavesMax;
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return (fromRadius == 1 || this.connectAnyRadius) && from.getFamily().isCompatibleDynamicLeaves(blockAccess.func_180495_p(pos), blockAccess, pos) ? 1 : 0;
    }

    @Override
    public int getFlammability() {
        return this.flammability;
    }

    @Override
    public int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    public void setLeavesUpdate(ILeavesUpdate leavesUpdate) {
        this.leavesUpdate = leavesUpdate;
    }

    @Override
    public boolean updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        return this.leavesUpdate.updateTick(worldIn, pos, state, rand, this);
    }

    public static void addLeavesFinderFunction(String finderName, Function<JsonElement, PrimitiveLeavesComponents> function) {
        blockstateFinderMap.put(finderName, function);
    }

    public static PrimitiveLeavesComponents findPrimitiveComponents(String finderName, JsonElement jsonElement) {
        Function<JsonElement, PrimitiveLeavesComponents> function = blockstateFinderMap.get(finderName);
        if (function != null) {
            return function.apply(jsonElement);
        }
        return new PrimitiveLeavesComponents(Blocks.field_150350_a.func_176223_P(), ItemStack.field_190927_a);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.colorMultiplier.func_186720_a(state, world, pos, -1);
    }

    @SideOnly(value=Side.CLIENT)
    private IBlockColor processColor(JsonPrimitive primitive) {
        int color = -1;
        if (primitive.isNumber()) {
            color = (Integer)primitive.getAsNumber();
        } else if (primitive.isString()) {
            String code = primitive.getAsString();
            if (code.startsWith("@")) {
                if ("biome".equals(code = code.substring(1))) {
                    return (state, world, pos, t) -> world.func_180494_b(pos).getModdedBiomeFoliageColor(super.foliageColorMultiplier(state, world, pos));
                }
                IBlockColor blockColor = BlockColorMultipliers.find(code);
                if (blockColor != null) {
                    return blockColor;
                }
                System.err.println("Error: ColorMultiplier resource \"" + code + "\" could not be found.");
            } else {
                color = Color.decode(code).getRGB();
            }
        }
        int c = color;
        return (s, w, p, t) -> c;
    }

    @SideOnly(value=Side.CLIENT)
    public void resolveClient() {
        if (this.colorPrimitive != null) {
            this.colorMultiplier = this.processColor(this.colorPrimitive);
            this.colorPrimitive = null;
        } else {
            this.colorMultiplier = (s, w, p, t) -> super.foliageColorMultiplier(s, w, p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void postInitClient() {
        for (LeavesPropertiesJson res : resolutionList) {
            res.resolveClient();
        }
    }

    public static interface ILeavesUpdate {
        public boolean updateTick(World var1, BlockPos var2, IBlockState var3, Random var4, ILeavesProperties var5);
    }

    public static class PrimitiveLeavesComponents {
        public IBlockState state;
        public ItemStack stack;

        public PrimitiveLeavesComponents(IBlockState state, ItemStack stack) {
            this.state = state;
            this.stack = stack;
        }

        public void assignTo(LeavesPropertiesJson lpJson) {
            lpJson.primitiveLeaves = this.state;
            lpJson.primitiveLeavesItemStack = this.stack;
        }
    }
}

